/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import untamedwilds.entity.amphibian.EntityNewt;

public class ModelNewt
extends AdvancedEntityModel<EntityNewt> {
    private final AdvancedModelBox body_main;
    private final AdvancedModelBox head_main;
    private final AdvancedModelBox body_hip;
    private final AdvancedModelBox arm_right;
    private final AdvancedModelBox arm_left;
    private final AdvancedModelBox body_crest;
    private final AdvancedModelBox gill_l_1;
    private final AdvancedModelBox gill_l_2;
    private final AdvancedModelBox gill_r_1;
    private final AdvancedModelBox gill_r_2;
    private final AdvancedModelBox tail_1;
    private final AdvancedModelBox leg_right;
    private final AdvancedModelBox leg_left;
    private final AdvancedModelBox tail_2;
    private final AdvancedModelBox tail_1_crest;

    public ModelNewt() {
        this.texWidth = 32;
        this.texHeight = 16;
        this.leg_left = new AdvancedModelBox((AdvancedEntityModel)this, 14, 5);
        this.leg_left.setRotationPoint(1.0f, 0.0f, 0.5f);
        this.leg_left.addBox(0.0f, -0.5f, -1.0f, 3.0f, 1.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_left, 0.0f, -0.4553564f, 0.57595867f);
        this.body_crest = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_crest.setRotationPoint(0.0f, -1.0f, 0.0f);
        this.body_crest.addBox(0.0f, -2.0f, -3.0f, 0.0f, 2.0f, 6.0f, 0.0f);
        this.tail_1_crest = new AdvancedModelBox((AdvancedEntityModel)this, 12, 4);
        this.tail_1_crest.setRotationPoint(0.0f, 0.0f, 2.5f);
        this.tail_1_crest.addBox(0.0f, -2.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f);
        this.tail_1 = new AdvancedModelBox((AdvancedEntityModel)this, 20, 10);
        this.tail_1.setRotationPoint(0.0f, -0.2f, 1.5f);
        this.tail_1.addBox(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.tail_1, -0.2443461f, 0.0f, 0.0f);
        this.tail_2 = new AdvancedModelBox((AdvancedEntityModel)this, 22, 4);
        this.tail_2.setRotationPoint(0.0f, 0.0f, 3.6f);
        this.tail_2.addBox(-0.5f, -0.5f, 0.0f, 1.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.tail_2, 0.13665928f, 0.0f, 0.0f);
        this.arm_right = new AdvancedModelBox((AdvancedEntityModel)this, 14, 5);
        this.arm_right.mirror = true;
        this.arm_right.setRotationPoint(-1.0f, 0.0f, -2.0f);
        this.arm_right.addBox(-3.0f, -0.5f, -1.0f, 3.0f, 1.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.arm_right, 0.0f, -0.5009095f, -0.57595867f);
        this.gill_l_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.gill_l_2.setRotationPoint(1.5f, -0.3f, -0.5f);
        this.gill_l_2.addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.gill_l_2, 0.0f, -0.5009095f, -0.18203785f);
        this.leg_right = new AdvancedModelBox((AdvancedEntityModel)this, 14, 5);
        this.leg_right.mirror = true;
        this.leg_right.setRotationPoint(-1.0f, 0.0f, 0.5f);
        this.leg_right.addBox(-3.0f, -0.5f, -1.0f, 3.0f, 1.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_right, 0.0f, 0.4553564f, -0.57595867f);
        this.arm_left = new AdvancedModelBox((AdvancedEntityModel)this, 14, 5);
        this.arm_left.setRotationPoint(1.0f, 0.0f, -2.0f);
        this.arm_left.addBox(0.0f, -0.5f, -1.0f, 3.0f, 1.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.arm_left, 0.0f, 0.5009095f, 0.63739425f);
        this.gill_r_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.gill_r_2.mirror = true;
        this.gill_r_2.setRotationPoint(-1.5f, -0.3f, -0.5f);
        this.gill_r_2.addBox(-2.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.gill_r_2, 0.0f, 0.5009095f, 0.18203785f);
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_main.setRotationPoint(0.0f, 22.3f, 0.0f);
        this.body_main.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.body_hip = new AdvancedModelBox((AdvancedEntityModel)this, 14, 0);
        this.body_hip.setRotationPoint(0.0f, 0.0f, 1.5f);
        this.body_hip.addBox(-1.51f, -1.0f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f);
        this.gill_r_1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.gill_r_1.mirror = true;
        this.gill_r_1.setRotationPoint(-1.5f, 0.3f, -0.5f);
        this.gill_r_1.addBox(-2.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.gill_r_1, 0.0f, 0.5009095f, -0.22759093f);
        this.head_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 10);
        this.head_main.setRotationPoint(0.0f, -0.3f, -2.8f);
        this.head_main.addBox(-1.5f, -1.01f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.head_main, 0.13665928f, 0.0f, 0.0f);
        this.head_main.scaleX = 1.05f;
        this.gill_l_1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.gill_l_1.setRotationPoint(1.5f, 0.3f, -0.5f);
        this.gill_l_1.addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.gill_l_1, 0.0f, -0.5009095f, 0.22759093f);
        this.body_hip.addChild((BasicModelPart)this.leg_left);
        this.body_main.addChild((BasicModelPart)this.body_crest);
        this.tail_1.addChild((BasicModelPart)this.tail_1_crest);
        this.body_hip.addChild((BasicModelPart)this.tail_1);
        this.tail_1.addChild((BasicModelPart)this.tail_2);
        this.body_main.addChild((BasicModelPart)this.arm_right);
        this.head_main.addChild((BasicModelPart)this.gill_l_2);
        this.body_hip.addChild((BasicModelPart)this.leg_right);
        this.body_main.addChild((BasicModelPart)this.arm_left);
        this.head_main.addChild((BasicModelPart)this.gill_r_2);
        this.body_main.addChild((BasicModelPart)this.body_hip);
        this.head_main.addChild((BasicModelPart)this.gill_r_1);
        this.body_main.addChild((BasicModelPart)this.head_main);
        this.head_main.addChild((BasicModelPart)this.gill_l_1);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.head_main, (Object)this.body_hip, (Object)this.arm_right, (Object)this.arm_left, (Object)this.leg_left, (Object)this.leg_right, (Object)this.body_crest, (Object)this.tail_1_crest, (Object)this.tail_2, (Object)this.tail_1, (Object)this.gill_l_1, (Object[])new AdvancedModelBox[]{this.gill_l_2, this.gill_r_1, this.gill_r_2});
    }

    public void setupAnim(EntityNewt newt, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float globalSpeed = 0.8f;
        float globalDegree = 1.0f;
        limbSwingAmount = Math.min(0.6f, limbSwingAmount);
        this.body_hip.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.body_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        if (!newt.m_5803_()) {
            this.faceTarget(netHeadYaw, headPitch, 2.0f, new AdvancedModelBox[]{this.head_main});
        }
        if (newt.m_20069_() && !newt.m_20096_()) {
            this.setRotateAngle(this.body_main, newt.m_146909_() * ((float)Math.PI / 180), 0.0f, 0.0f);
        }
        this.head_main.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.head_main.rotateAngleY, (float)newt.offset);
        this.body_hip.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.body_hip.rotateAngleY, (float)(-1.0f * newt.offset));
        this.tail_2.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.tail_2.rotateAngleY, (float)(-2.0f * newt.offset));
        AdvancedModelBox[] bodyParts = new AdvancedModelBox[]{this.head_main, this.body_main, this.body_hip, this.tail_1, this.tail_2};
        this.chainSwing(bodyParts, globalSpeed * 1.4f, globalDegree * 1.2f, -4.0, limbSwing, limbSwingAmount * 0.3f);
        float onGround = Math.min(0.8f, limbSwingAmount * (float)(newt.m_20096_() ? 2 : 1));
        if (newt.m_20069_()) {
            this.flap(this.arm_left, globalSpeed, globalDegree, false, 0.8f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left, globalSpeed, globalDegree * 0.8f, false, 1.6f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right, globalSpeed, globalDegree, false, 2.4f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right, globalSpeed, globalDegree * 0.8f, false, 3.2f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
            this.swing(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.8f, 0.1f, limbSwing / 3.0f, limbSwingAmount);
            this.chainWave(new AdvancedModelBox[]{this.head_main, this.body_main, this.body_hip}, globalSpeed * 0.8f, globalDegree, -4.0, limbSwing, limbSwingAmount * 0.2f);
        } else {
            this.swing(this.arm_left, globalSpeed, globalDegree * 1.2f, false, 0.8f, 1.0f, limbSwing, onGround);
            this.swing(this.leg_left, globalSpeed, globalDegree * 1.1f, false, 1.6f, 1.0f, limbSwing, onGround);
            this.swing(this.arm_right, globalSpeed, globalDegree * 1.2f, false, 2.4f, 1.0f, limbSwing, onGround);
            this.swing(this.leg_right, globalSpeed, globalDegree * 1.1f, false, 3.2f, 1.0f, limbSwing, onGround);
        }
        if (newt.swimProgress > 0) {
            this.progressRotation(this.arm_right, newt.swimProgress, (float)Math.toRadians(41.74f), (float)Math.toRadians(70.43f), (float)Math.toRadians(-36.52f), 20.0f);
            this.progressRotation(this.arm_left, newt.swimProgress, (float)Math.toRadians(41.74f), (float)Math.toRadians(-70.43f), (float)Math.toRadians(36.52f), 20.0f);
            this.progressRotation(this.leg_right, newt.swimProgress, (float)Math.toRadians(49.57f), (float)Math.toRadians(73.04f), (float)Math.toRadians(-33.91f), 20.0f);
            this.progressRotation(this.leg_left, newt.swimProgress, (float)Math.toRadians(49.57f), (float)Math.toRadians(-73.04f), (float)Math.toRadians(33.91f), 20.0f);
        }
    }
}

